/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.types.IArmorMaterialTFC;
import net.dries007.tfc.objects.blocks.metal.BlockTrapDoorMetalTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockMetalLamp;
import net.dries007.tfc.objects.items.metal.ItemAnvil;
import net.dries007.tfc.objects.items.metal.ItemIngot;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.objects.items.metal.ItemMetalArmor;
import net.dries007.tfc.objects.items.metal.ItemMetalBucket;
import net.dries007.tfc.objects.items.metal.ItemMetalChisel;
import net.dries007.tfc.objects.items.metal.ItemMetalHoe;
import net.dries007.tfc.objects.items.metal.ItemMetalJavelin;
import net.dries007.tfc.objects.items.metal.ItemMetalShears;
import net.dries007.tfc.objects.items.metal.ItemMetalSheet;
import net.dries007.tfc.objects.items.metal.ItemMetalShield;
import net.dries007.tfc.objects.items.metal.ItemMetalSword;
import net.dries007.tfc.objects.items.metal.ItemMetalTool;
import net.dries007.tfc.objects.items.metal.ItemProspectorPick;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Metal
extends IForgeRegistryEntry.Impl<Metal> {
    @GameRegistry.ObjectHolder(value="tfc:unknown")
    public static final Metal UNKNOWN = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:wrought_iron")
    public static final Metal WROUGHT_IRON = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:gold")
    public static final Metal GOLD = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:pig_iron")
    public static final Metal PIG_IRON = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:bronze")
    public static final Metal BRONZE = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:bismuth_bronze")
    public static final Metal BISMUTH_BRONZE = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:steel")
    public static final Metal STEEL = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:black_bronze")
    public static final Metal BLACK_BRONZE = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:blue_steel")
    public static final Metal BLUE_STEEL = (Metal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="tfc:red_steel")
    public static final Metal RED_STEEL = (Metal)((Object)Helpers.getNull());
    private final Tier tier;
    private final float specificHeat;
    private final float meltTemp;
    private final boolean usable;
    private final int color;
    private final Item.ToolMaterial toolMetal;
    private final IArmorMaterialTFC armorMetal;

    public Metal(@Nonnull ResourceLocation name, Tier tier, boolean usable, float specificHeat, float meltTemp, int color, @Nullable Item.ToolMaterial toolMetal, @Nullable IArmorMaterialTFC armorMetal) {
        this.usable = usable;
        this.tier = tier;
        this.specificHeat = specificHeat;
        this.meltTemp = meltTemp;
        this.color = color;
        this.toolMetal = toolMetal;
        this.armorMetal = armorMetal;
        this.setRegistryName(name);
    }

    @Nullable
    public Item.ToolMaterial getToolMetal() {
        return this.toolMetal;
    }

    @Nullable
    public IArmorMaterialTFC getArmorMetal() {
        return this.armorMetal;
    }

    public boolean isToolMetal() {
        return this.getToolMetal() != null;
    }

    public boolean isArmorMetal() {
        return this.getArmorMetal() != null;
    }

    public Tier getTier() {
        return this.tier;
    }

    public float getSpecificHeat() {
        return this.specificHeat;
    }

    public float getMeltTemp() {
        return this.meltTemp;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public int getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return "tfc.types.metal." + this.getRegistryName().func_110623_a();
    }

    public String toString() {
        return this.getRegistryName().func_110623_a();
    }

    public static enum ItemType {
        INGOT(false, -1, 100, ItemIngot::new, true, "XXXX", "X  X", "X  X", "X  X", "XXXX"),
        DOUBLE_INGOT(false, 200),
        SCRAP(false, 100),
        DUST(false, 100),
        NUGGET(false, 10),
        SHEET(false, 200, ItemMetalSheet::new),
        DOUBLE_SHEET(false, 400),
        ROD(false, 50),
        ANVIL(true, 1400, ItemAnvil::new),
        TUYERE(true, 400),
        LAMP(false, 100, (metal, itemType) -> new ItemBlockMetalLamp((Metal)((Object)metal))),
        TRAPDOOR(false, 200, (metal, itemType) -> new ItemBlock((Block)BlockTrapDoorMetalTFC.get(metal))),
        PICK(true, 100, ItemMetalTool::new),
        PICK_HEAD(true, 100, true, "XXXXX", "X   X", " XXX ", "XXXXX"),
        SHOVEL(true, 100, ItemMetalTool::new),
        SHOVEL_HEAD(true, 100, true, "X   X", "X   X", "X   X", "X   X", "XX XX"),
        AXE(true, 100, ItemMetalTool::new),
        AXE_HEAD(true, 100, true, "X XXX", "    X", "     ", "    X", "X XXX"),
        HOE(true, 100, ItemMetalHoe::new),
        HOE_HEAD(true, 100, true, "XXXXX", "     ", "  XXX", "XXXXX"),
        CHISEL(true, 100, ItemMetalChisel::new),
        CHISEL_HEAD(true, 100, true, "X X", "X X", "X X", "X X", "X X"),
        SWORD(true, 100, (metal, itemType) -> new ItemMetalSword((Metal)((Object)metal))),
        SWORD_BLADE(true, 100, true, "XXX  ", "XX   ", "X   X", "X  XX", " XXXX"),
        MACE(true, 100, ItemMetalTool::new),
        MACE_HEAD(true, 100, true, "XX XX", "X   X", "X   X", "X   X", "XX XX"),
        SAW(true, 100, ItemMetalTool::new),
        SAW_BLADE(true, 100, true, "XXX  ", "XX   ", "X   X", "    X", "  XXX"),
        JAVELIN(true, 100, ItemMetalJavelin::new),
        JAVELIN_HEAD(true, 100, true, "XX   ", "X    ", "     ", "X   X", "XX XX"),
        HAMMER(true, 100, ItemMetalTool::new),
        HAMMER_HEAD(true, 100, true, "XXXXX", "     ", "     ", "XX XX", "XXXXX"),
        PROPICK(true, 100, ItemProspectorPick::new),
        PROPICK_HEAD(true, 100, true, "XXXXX", "    X", " XXX ", " XXXX", "XXXXX"),
        KNIFE(true, 100, ItemMetalTool::new),
        KNIFE_BLADE(true, 100, true, "XX X", "X  X", "X  X", "X  X", "X  X"),
        SCYTHE(true, 100, ItemMetalTool::new),
        SCYTHE_BLADE(true, 100, true, "XXXXX", "X    ", "    X", "  XXX", "XXXXX"),
        SHEARS(true, 200, ItemMetalShears::new),
        UNFINISHED_HELMET(true, 400),
        HELMET(true, 0, 600, ItemMetalArmor::new),
        UNFINISHED_CHESTPLATE(true, 400),
        CHESTPLATE(true, 1, 800, ItemMetalArmor::new),
        UNFINISHED_GREAVES(true, 400),
        GREAVES(true, 2, 600, ItemMetalArmor::new),
        UNFINISHED_BOOTS(true, 200),
        BOOTS(true, 3, 400, ItemMetalArmor::new),
        SHIELD(true, 400, ItemMetalShield::new),
        BUCKET(false, 200, ItemMetalBucket::new);

        private final boolean toolItem;
        private final int armorSlot;
        private final int smeltAmount;
        private final boolean hasMold;
        private final BiFunction<Metal, ItemType, Item> supplier;
        private final String[] pattern;

        public static Item create(Metal metal, ItemType type) {
            return type.supplier.apply(metal, type);
        }

        private ItemType(boolean toolItem, @Nonnull int armorSlot, int smeltAmount, BiFunction<Metal, ItemType, Item> supplier, boolean hasMold, String ... moldPattern) {
            this.toolItem = toolItem;
            this.armorSlot = armorSlot;
            this.smeltAmount = smeltAmount;
            this.supplier = supplier;
            this.hasMold = hasMold;
            this.pattern = moldPattern;
        }

        private ItemType(boolean toolItem, int smeltAmount, boolean hasMold, String ... moldPattern) {
            this(toolItem, -1, smeltAmount, ItemMetal::new, hasMold, moldPattern);
        }

        private ItemType(boolean toolItem, int smeltAmount) {
            this(toolItem, smeltAmount, false, new String[0]);
        }

        private ItemType(boolean toolItem, @Nonnull int armorSlot, int smeltAmount, BiFunction<Metal, ItemType, Item> supplier) {
            this(toolItem, armorSlot, smeltAmount, supplier, false, new String[0]);
        }

        private ItemType(@Nonnull boolean toolItem, int smeltAmount, BiFunction<Metal, ItemType, Item> supplier) {
            this(toolItem, -1, smeltAmount, supplier, false, new String[0]);
        }

        public boolean hasType(Metal metal) {
            if (!metal.isUsable()) {
                return this == INGOT;
            }
            if (this == BUCKET) {
                return metal == BLUE_STEEL || metal == RED_STEEL;
            }
            if (this == ROD) {
                return metal == WROUGHT_IRON || metal == STEEL || metal == GOLD;
            }
            if (this == LAMP) {
                return metal != PIG_IRON;
            }
            return !this.isToolItem() || metal.getToolMetal() != null;
        }

        public boolean hasMold(@Nullable Metal metal) {
            if (metal == null) {
                return this.hasMold;
            }
            if (this == INGOT) {
                return true;
            }
            if (this.hasMold) {
                return metal.isToolMetal() && metal.getTier().isAtMost(Tier.TIER_II);
            }
            return false;
        }

        public boolean isToolItem() {
            return this.toolItem;
        }

        public int getArmorSlot() {
            return this.armorSlot;
        }

        public boolean isArmor() {
            return this.armorSlot != -1;
        }

        public EntityEquipmentSlot getEquipmentSlot() {
            switch (this.armorSlot) {
                case 0: {
                    return EntityEquipmentSlot.HEAD;
                }
                case 1: {
                    return EntityEquipmentSlot.CHEST;
                }
                case 2: {
                    return EntityEquipmentSlot.LEGS;
                }
                case 3: {
                    return EntityEquipmentSlot.FEET;
                }
            }
            return EntityEquipmentSlot.MAINHAND;
        }

        public int getSmeltAmount() {
            return this.smeltAmount;
        }

        public String[] getPattern() {
            return this.pattern;
        }
    }

    public static enum Tier {
        TIER_0,
        TIER_I,
        TIER_II,
        TIER_III,
        TIER_IV,
        TIER_V,
        TIER_VI;

        private static final Tier[] VALUES;

        @Nonnull
        public static Tier valueOf(int tier) {
            return tier < 0 || tier > VALUES.length ? TIER_I : VALUES[tier];
        }

        @Nonnull
        public Tier next() {
            return this == TIER_VI ? TIER_VI : VALUES[this.ordinal() + 1];
        }

        @Nonnull
        public Tier previous() {
            return this == TIER_0 ? TIER_0 : VALUES[this.ordinal() - 1];
        }

        public boolean isAtLeast(@Nonnull Tier requiredInclusive) {
            return this.ordinal() >= requiredInclusive.ordinal();
        }

        public boolean isAtMost(@Nonnull Tier requiredInclusive) {
            return this.ordinal() <= requiredInclusive.ordinal();
        }

        static {
            VALUES = Tier.values();
        }
    }
}

